
#ifndef SEC_BOOT_FLASH_H
#define SEC_BOOT_FLASH_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 24 15:06:56 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version flash.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */




/************************ Defines ******************************/

#define MAX_INTERNAL_RAM_WORK_SIZE_IN_BYTES 6144

/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

/**
 * @brief The Flash interface function - needed to be implemented by customer:
 *         
 * @param[in] DestAddr_ptr   -  The destination address in working memory.
 * @param[in] startFlashAddr -  the start address in the flash.
 * @param[in] sizeInWords    -  The size in words.
 */                              
void GetFlashData( DxUint32_t *DestAddr_ptr, 
                   DxUint32_t startFlashAddr, 
                   DxUint32_t sizeInWords );




#ifdef __cplusplus
}
#endif

#endif


